/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.blocks;

import com.alcatrazescapee.alcatrazcore.util.CoreHelpers;
import com.alcatrazescapee.alcatrazcore.util.OreDictionaryHelper;
import com.alcatrazescapee.alcatrazcore.util.RegistryHelper;
import com.alcatrazescapee.notreepunching.client.ModTabs;
import com.alcatrazescapee.notreepunching.common.blocks.BlockCobble;
import com.alcatrazescapee.notreepunching.common.blocks.BlockFirePit;
import com.alcatrazescapee.notreepunching.common.blocks.BlockLargeVessel;
import com.alcatrazescapee.notreepunching.common.blocks.BlockPottery;
import com.alcatrazescapee.notreepunching.common.blocks.BlockRock;
import com.alcatrazescapee.notreepunching.common.tile.TileFirePit;
import com.alcatrazescapee.notreepunching.common.tile.TileLargeVessel;
import com.alcatrazescapee.notreepunching.util.types.Pottery;
import com.alcatrazescapee.notreepunching.util.types.Stone;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.registry.GameRegistry;

@GameRegistry.ObjectHolder(value="notreepunching")
public final class ModBlocks {
    public static final Block CERAMIC_LARGE_VESSEL = (Block)CoreHelpers.getNull();
    public static final Block FIRE_PIT = (Block)CoreHelpers.getNull();

    public static void preInit() {
        RegistryHelper r = RegistryHelper.get((String)"notreepunching");
        for (Stone stone : Stone.values()) {
            if (!stone.isEnabled()) continue;
            if (stone.hasCobblestone()) {
                r.registerBlock((Block)new BlockCobble(stone), "cobblestone/" + stone.name(), ModTabs.TAB_ITEMS);
            }
            r.registerBlock((Block)new BlockRock(stone), null, "loose_rock/" + stone.name());
        }
        for (Enum enum_ : Pottery.values()) {
            BlockPottery block = new BlockPottery((Pottery)enum_);
            r.registerBlock((Block)block, enum_ == Pottery.WORKED ? null : ItemBlock::new, "pottery/" + enum_.name(), ModTabs.TAB_ITEMS);
            if (enum_ == Pottery.WORKED) continue;
            OreDictionaryHelper.register((Block)block, (Object[])new Object[]{"clay", enum_.name()});
        }
        r.registerBlock((Block)new BlockLargeVessel(), "ceramic_large_vessel", ModTabs.TAB_ITEMS);
        r.registerBlock((Block)new BlockFirePit(), null, "fire_pit");
        r.registerTile(TileLargeVessel.class, "ceramic_large_vessel");
        r.registerTile(TileFirePit.class, "fire_pit");
    }
}

